//
//  MCCSWCanvas.h
//  CollapsibleWidget
//
//  Created by Michael Clark on 11/07/2005.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCCollapsibleSheetWidget;

@interface MCCSWCanvasView : NSView {
	
	NSColor*         __bgColor;
	
	// Animation support
	NSTimer*                     __collapseAnimationTimer;
	MCCollapsibleSheetWidget*    __collapsingWidget;
	NSTimer*                     __deletingAnimationTimer;
	MCCollapsibleSheetWidget*    __deletingWidget;
	
	NSMutableArray*              __movingWidgets;

	float __preferredHeight;
	BOOL  __handlesScrolling;

	// Dragging
	MCCollapsibleSheetWidget *__draggedWidget;
	NSInteger __draggedIndex;    // what index it's sitting at currently
	float __draggedHeight; // height of dragged widget
	NSTimer *__draggingAnimationTimer;
}

- (void)addWidget: (MCCollapsibleSheetWidget*)aWidget;
- (void)removeWidget: (MCCollapsibleSheetWidget*)aWidget;
- (void)clearWidgets; // Removed all the current widgets
- (void)collapseWidget: (MCCollapsibleSheetWidget*)aWidget;
- (void)expandWidget: (MCCollapsibleSheetWidget*)aWidget;


// This should need to be called by users of a canvas, but in come situations subclasses might need to call it
- (void)tile;
- (float)preferredHeight;

- (IBAction)takeColorFromControl: (id)sender;


// Dragging
- (NSDragOperation)draggingUpdatedAtLocation:(NSPoint)aPoint;
- (void)dragAnimateWidgets;


#pragma mark Accessors
- (BOOL)handlesScrolling;
- (void)setHandlesScrolling:(BOOL)flag;

@end
